﻿
//Asignacion de valores por defecto de los calendarios
$.fn.datepicker.defaults.format = "dd/mm/yyyy";
$.fn.datepicker.defaults.language = "es";
$.fn.datepicker.defaults.autoclose = true;

var HistoricalType_Lineal = 0;
var HistoricalType_Area = 1;
var HistoricalType_HorizonalBar = 3;
var HistoricalType_VerticalBar = 4;
Chart.types.Line.extend({
    name: "LineWithYLine",
    draw: function () {
        Chart.types.Line.prototype.draw.apply(this, arguments);

        var scale = this.scale
        var ctx = this.chart.ctx;
        // calculate using the scale
        if (this.options.linesAts !== undefined) {
            for (i = 0; i < this.options.linesAts.length; i++) {
                var y = scale.calculateY(this.options.linesAts[i][1]);
                ctx.save();
                switch (this.options.linesAts[i][0]) {
                    case "0":
                        ctx.strokeStyle = '#00ff00';
                        break;
                    case "1":
                        ctx.strokeStyle = '#FFF549';
                        break;
                    case "2":
                        ctx.strokeStyle = '#ff0000';
                        break;
                }
                ctx.beginPath();
                ctx.moveTo(Math.round(scale.xScalePaddingLeft), y);
                ctx.lineTo(this.chart.width, y);
                ctx.stroke();
                ctx.restore();
            }
        }
    }
});
Chart.types.Bar.extend({
    name: "BarWithYLine",
    draw: function () {
        Chart.types.Bar.prototype.draw.apply(this, arguments);

        var scale = this.scale
        var ctx = this.chart.ctx;
        // calculate using the scale
        if (this.options.linesAts !== undefined) {
            for (i = 0; i < this.options.linesAts.length; i++) {
                var y = scale.calculateY(this.options.linesAts[i][1]);
                ctx.save();
                switch (this.options.linesAts[i][0]) {
                    case "0":
                        ctx.strokeStyle = '#00ff00';
                        break;
                    case "1":
                        ctx.strokeStyle = '#FFF549';
                        break;
                    case "2":
                        ctx.strokeStyle = '#ff0000';
                        break;
                }

                ctx.beginPath();
                ctx.moveTo(Math.round(scale.xScalePaddingLeft), y);
                ctx.lineTo(this.chart.width, y);
                ctx.stroke();
                ctx.restore();
            }
        }
    }
});

function kpi_filter_Search(src) {
    var kpid = $('#mdlKPIFilter').find('input[id="mdlKPIFilter_KPIId"]').val();
    var params = $('#mdlKPIFilter').find('input[id="mdlKPIFilter_Params"]').val();
    var cant = 0;// $('#mdlKPIFilter').find('select[id="optCantidad"]').val();
    var dtDesdeTemp = new Date($('#grpDesde').datepicker("getDate"));
    var dtHastaTemp = new Date($('#grpHasta').datepicker("getDate"));
    var dtDesde = dtDesdeTemp.toISOString().substring(0, 10);
    var dtHasta = dtHastaTemp.toISOString().substring(0, 10);
    $("#divHistoricalChart" + kpid).data('ini', dtDesde);
    $("#divHistoricalChart" + kpid).data('end', dtHasta);
    getValue(kpid, params, '0', dtDesde, dtHasta, cant, false)
}
function kpi_filter_Initialize(e) {
    var id = $(e.relatedTarget).data('id');
    var params = $("#divHistoricalChart" + id).data('params');
    var dtDesde = $("#divHistoricalChart" + id).data('ini');
    var dtHasta = $("#divHistoricalChart" + id).data('end');
    var cant = $("#divHistoricalChart" + id).data('cant');
    if (id !== undefined)
        $(e.currentTarget).find('input[id="mdlKPIFilter_KPIId"]').val(id);
    if (params !== undefined)
        $(e.currentTarget).find('input[id="mdlKPIFilter_Params"]').val(params);
    if (dtDesde !== undefined) {
        datePartsDesde = dtDesde.match(/(\d+)/g)
        realDateDesde = new Date(datePartsDesde[0], datePartsDesde[1] - 1, datePartsDesde[2]);
        $('#grpDesde').datepicker('setDate', realDateDesde);
    }
    if (dtHasta !== undefined) {
        datePartsHasta = dtHasta.match(/(\d+)/g)
        realDateHasta = new Date(datePartsHasta[0], datePartsHasta[1] - 1, datePartsHasta[2]);
        $('#grpHasta').datepicker('setDate', realDateHasta);
    }
    //if (cant !== undefined)
    //    $(e.currentTarget).find('input[id="mdlKPIFilter_Params"]').val(cant);
}
function kpi_filter_SetStartDate(selected) {
    var minDate = new Date(selected.date.valueOf());
    $('#grpHasta').datepicker('setStartDate', minDate);
}
function kpi_filter_SetEndDate(selected) {
    var minDate = new Date(selected.date.valueOf());
    $('#grpDesde').datepicker('setEndDate', minDate);
}
function kpi_showModal(e) {
    var id = $(e.relatedTarget).data('id');
    var params = $("#divHistoricalChart" + id).data('params');
    var dtDesde = $("#divHistoricalChart" + id).data('ini');
    var dtHasta = $("#divHistoricalChart" + id).data('end');
    var cant = $("#divHistoricalChart" + id).data('cant');
    getValue(id, params, '0', dtDesde, dtHasta, cant, true)
}
function remarkKPI(id, counter, marked) {
    var elem = $("#divHistoricalChart" + id);
    var clase = elem.attr("class");
    elem.removeClass(clase)

    if (marked)
        elem.addClass("box box-info")
    else
        elem.addClass("box box-warning")
    counter++;
    if (counter < 10)
        setTimeout(remarkKPI, 500, id, counter, !marked);
}
function refreshAllKPI() {
    $.each($("#rowKPIRealTime div[data-type='kpirealtime']"), function () {
        getValue($(this).attr("data-kpiid"), $(this).attr("data-params"), '1', '', '', 20, false);
    });
}
function mdlKPIRefresh(src) {
    var id = $(src).data("id");
    var params = $("#divHistoricalChart" + id).data('params');
    var dtDesde = $("#divHistoricalChart" + id).data('ini');
    var dtHasta = $("#divHistoricalChart" + id).data('end');
    var cant = $("#divHistoricalChart" + id).data('cant');
    getValue(id, params, '0', dtDesde, dtHasta, cant, false)
}
function getValue(id, params, currentvalue, dtD, dtH, cant, fullsize) {
    var szKey = id;
    var szParam = "'pKey' : '" + szKey + "', 'pParam':'" + params + "', 'pCurrentValue':'" + currentvalue + "'";
    if (dtD !== '') szParam = szParam + ",'pdtD':'" + dtD + "'";
    if (dtH !== '') szParam = szParam + ",'pdtH':'" + dtH + "'";
    if (cant !== '') szParam = szParam + ",'pCant':'" + cant + "'";
    $.ajax({
        url: getKPIInfoURL(), // '@Url.Action("GetKPIInfo", "BAM")',
        type: 'POST',
        data: '{' + szParam + '}',
        dataType: "json",
        cache: false,
        contentType: "application/json; charset=utf-8",
        async: true,
        success: function (resp) {
            if (resp.status === 200) {
                jsondata = resp.data;
                if (currentvalue === '1')
                    drawRealTimeGraphic(id, jsondata, fullsize);
                $("#divHistoricalChart" + id).data('cant', jsondata.HistoricalCount);
                switch (jsondata.HistoricalType) {
                    case HistoricalType_Lineal:
                        drawLineChart(id, jsondata, false, fullsize);
                        break;
                    case HistoricalType_Area:
                        drawLineChart(id, jsondata, true, fullsize);
                        break;
                    default:
                        drawBarChar(id, jsondata, fullsize);
                }
            }
            else if (resp.status === 302) {
                window.location.href = resp.data;
            }
            else if (resp.status === 500) {
                alert(resp.data);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            Common.ShowError(xhr, ajaxOptions, thrownError);
        }
    });
};
function resetCanvas(id) {

    if (id === 0) {
        $("#mdlKPIShowhistoricalChart").remove(); // this is my <canvas> element
        $("#mdlKPIShowParenthistoricalChart").append('<canvas id="mdlKPIShowhistoricalChart">');
    }
    else {
        $("#historicalChart" + id).remove(); // this is my <canvas> element
        $("#ParenthistoricalChart" + id).append('<canvas id="historicalChart' + id + '" style="height:250px"></canvas>');
    }
    /*  canvas = document.querySelector('#results-graph');
      ctx = canvas.getContext('2d');
      ctx.canvas.width = $('#graph').width(); // resize to parent width
      ctx.canvas.height = $('#graph').height(); // resize to parent height
      *//*
                var x = canvas.width / 2;
                var y = canvas.height / 2;
                ctx.font = '10pt Verdana';
                ctx.textAlign = 'center';
                ctx.fillText('This text is centered on the canvas', x, y);
                */
};
function getLines(linesAts) {
    var lines = [];
    if (linesAts !== undefined) {
        if (linesAts !== "") {
            var arrValues = (linesAts + "#").split('#');
            for (var i = 1; i < arrValues.length ; i++) {
                if (arrValues[i] !== null && arrValues[i] !== "") {
                    var arrItemValues = (arrValues[i] + ":").split(':');
                    if (arrItemValues.length > 2 && arrItemValues[0] !== null && arrItemValues[0] !== "") {
                        lines.push(new Array(arrItemValues[0], arrItemValues[1]));
                    }
                }
            }
        }
    }
    return lines;
}
function drawRealTimeGraphic(id, jsondata, fullsize) {
    if (fullsize)
        return;
    var canvas = $("#divRealTimeChart" + id);

    if (jsondata.CurrentValue !== undefined)
        canvas.find("span.info-box-number").text(jsondata.CurrentValue);

    if (jsondata.CurrentValueDate !== undefined)
        canvas.find("span.progress-description").text("Actualizado: " + jsondata.CurrentValueDateShort);

    if (jsondata.CurrentValue !== undefined) {

        canvas.find("i[data-type='icon']").removeAttr('style');
        var clase = canvas.find("i[data-type='icon']").attr("class");
        canvas.find("i[data-type='icon']").removeClass(clase)
        canvas.find("i[data-type='icon']").addClass(jsondata.CurrentIcon)
    }

    if (jsondata.CurrentProgressStyle !== undefined) {
        canvas.find("div.progress-bar").css('width', jsondata.CurrentProgressStyle);
        if (jsondata.CurrentProgressColor !== undefined)
            canvas.find("div.progress-bar").css('background-color', jsondata.CurrentProgressColor);
        else
            canvas.find("div.progress-bar").css('background-color', "blue");
    }

    if (jsondata.CurrentColor !== undefined) {

        var clasecolor = canvas.find("span[data-type='color']").attr("class");
        canvas.find("span[data-type='color']").removeClass(clasecolor)
        canvas.find("span[data-type='color']").addClass(jsondata.CurrentColor)
    }

}
function drawBarChar(id, jsondata, fullsize) {
    var canvas;
    if (fullsize) {
        resetCanvas(0);
        canvas = $("#mdlKPIShowhistoricalChart").get(0).getContext("2d");
    }
    else {
        resetCanvas(id);
        canvas = $("#historicalChart" + id).get(0).getContext("2d");
    }
    var szlabel = jsondata.HistoricalLabelArray.split(',');
    var szvalues = jsondata.HistoricalValuesArray.split(',');
    var lines = getLines(jsondata.ValueRangeAsString);
    var data = {
        labels: szlabel,
        datasets: [
          {
              label: "",
              fillColor: "rgba(60,141,188,0.9)",
              strokeColor: "rgba(60,141,188,0.8)",
              pointColor: "#3b8bba",
              pointStrokeColor: "rgba(60,141,188,1)",
              pointHighlightFill: "#fff",
              pointHighlightStroke: "rgba(60,141,188,1)",
              data: szvalues
          }
        ]
    };
    new Chart(canvas).BarWithYLine(data, {
        //Boolean - Whether the scale should start at zero, or an order of magnitude down from the lowest value
        scaleBeginAtZero: true,
        //Boolean - Whether grid lines are shown across the chart
        scaleShowGridLines: true,
        //String - Colour of the grid lines
        scaleGridLineColor: "rgba(0,0,0,.05)",
        //Number - Width of the grid lines
        scaleGridLineWidth: 1,
        //Boolean - Whether to show horizontal lines (except X axis)
        scaleShowHorizontalLines: true,
        //Boolean - Whether to show vertical lines (except Y axis)
        scaleShowVerticalLines: true,
        //Boolean - If there is a stroke on each bar
        barShowStroke: true,
        //Number - Pixel width of the bar stroke
        barStrokeWidth: 2,
        //Number - Spacing between each of the X value sets
        barValueSpacing: 5,
        //Number - Spacing between data sets within X values
        barDatasetSpacing: 1,
        //solo visualiza el valor y no la leyenda
        tooltipTemplate: "<%= value %>",
        //String - A legend template
        //legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].fillColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
        //Boolean - whether to make the chart responsive
        responsive: true,
        maintainAspectRatio: true,
        linesAts: lines
    });
}
function drawLineChart(id, jsondata, filled, fullsize) {

    // Get context with jQuery - using jQuery's .get() method.
    var canvas;
    if (fullsize) {
        resetCanvas(0);
        canvas = $("#mdlKPIShowhistoricalChart").get(0).getContext("2d");
    }
    else {
        resetCanvas(id);
        canvas = $("#historicalChart" + id).get(0).getContext("2d");
    }
    var szlabel = jsondata.HistoricalLabelArray.split(',');
    var szvalues = jsondata.HistoricalValuesArray.split(',');
    var lines = getLines(jsondata.ValueRangeAsString);
    var data = {
        labels: szlabel,
        datasets: [
          {
              label: "",
              fillColor: "rgba(60,141,188,0.9)",
              strokeColor: "rgba(60,141,188,0.8)",
              pointColor: "#3b8bba",
              pointStrokeColor: "rgba(60,141,188,1)",
              pointHighlightFill: "#fff",
              pointHighlightStroke: "rgba(60,141,188,1)",
              data: szvalues
          }
        ]
    };
    new Chart(canvas).LineWithYLine(data, {
        scaleBeginAtZero: true,
        //Boolean - If we should show the scale at all
        showScale: true,
        //Boolean - Whether grid lines are shown across the chart
        scaleShowGridLines: false,
        //String - Colour of the grid lines
        scaleGridLineColor: "rgba(0,0,0,.05)",
        //Number - Width of the grid lines
        scaleGridLineWidth: 1,
        //Boolean - Whether to show horizontal lines (except X axis)
        scaleShowHorizontalLines: true,
        //Boolean - Whether to show vertical lines (except Y axis)
        scaleShowVerticalLines: true,
        //Boolean - Whether the line is curved between points
        bezierCurve: true,
        //Number - Tension of the bezier curve between points
        bezierCurveTension: 0.3,
        //Boolean - Whether to show a dot for each point
        pointDot: false,
        //Number - Radius of each point dot in pixels
        pointDotRadius: 4,
        //Number - Pixel width of point dot stroke
        pointDotStrokeWidth: 1,
        //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
        pointHitDetectionRadius: 20,
        //Boolean - Whether to show a stroke for datasets
        datasetStroke: true,
        //Number - Pixel width of dataset stroke
        datasetStrokeWidth: 2,
        //Boolean - Whether to fill the dataset with a color
        datasetFill: filled,
        tooltipTemplate: "<%= value %>",
        //String - A legend template
        //legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].fillColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
        //Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
        maintainAspectRatio: true,
        //Boolean - whether to make the chart responsive to window resizing
        responsive: true,
        linesAts: lines
    });


}

